/** @type {import('tailwindcss').Config} */
export default {
    content: [
        "./resources/**/*.antlers.html",
        "./resources/**/*.antlers.php",
        "./resources/**/*.blade.php",
        "./resources/**/*.vue",
        "./content/**/*.md",
    ],

    theme: {
        extend: {
            colors: {
                "hover-brand-pink": "#FF6E95",
                "brand-pink": "#F0537D",
                "brand-yellow": "#F7C645",
                "brand-blue": "#314CD7",
                "hover-brand-navy": "#2E3166",
                "brand-navy": "#12143D",
                "not-black": "#111",
            },
            screens: {
                xxs: "375px",
                xs: "480px",
                "3xl": "2000px",
            },
            spacing: {
                15: "3.75rem",
                18: "4.5rem",
                22: "5.5rem",
                25: "6.25rem",
                30: "7.5rem",
                66: "16.5rem",
                76: "19rem",
                84: "21rem",
                88: "22rem",
                90: "22.5rem",
                100: "25rem",
                200: "50rem",
                204: "51rem",
            },
        },
        fontFamily: {
            figtree: ["Figtree", "sans-serif"],
            dmsans: ["DM Sans", "sans-serif"],
        },
        fontSize: {
            sm: "0.875rem",
            base: "1.125rem",
            md: "1.375rem",
            lg: "1.625rem",
            xl: "2.25rem",
            "2xl": [
                "3.1875rem",
                {
                    fontWeight: "800",
                },
            ],
            "3xl": [
                "4.5rem",
                {
                    fontWeight: "800",
                    letterSpacing: "-0.09rem",
                },
            ],
            "4xl": [
                "9rem",
                {
                    fontWeight: "800",
                    letterSpacing: "-0.18rem",
                },
            ],
        },
    },

    plugins: [require("@tailwindcss/typography")],
};
