<?php use function Statamic\trans as __; ?>


<?php $__env->startSection('title', __('Roles')); ?>

<?php $__env->startSection('content'); ?>

    <?php if (! ($roles->isEmpty())): ?>

        <header class="flex items-center justify-between mb-6">
            <h1><?php echo e(__('Roles & Permissions')); ?></h1>
            <a href="<?php echo e(cp_route('roles.create')); ?>" class="btn-primary"><?php echo e(__('Create Role')); ?></a>
        </header>

        <role-listing
            :initial-rows="<?php echo e(json_encode($roles)); ?>"
            :initial-columns="<?php echo e(json_encode($columns)); ?>">
        </role-listing>

    <?php else: ?>

        <?php echo $__env->make('statamic::partials.empty-state', [
            'title' => __('Roles & Permissions'),
            'description' => __('statamic::messages.role_intro'),
            'svg' => 'empty/users',
            'button_text' => __('Create Role'),
            'button_url' => cp_route('roles.create'),
        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php endif; ?>

    <?php echo $__env->make('statamic::partials.docs-callout', [
        'topic' => __('Roles & Permissions'),
        'url' => Statamic::docsUrl('users#permissions')
    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('statamic::layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/amperative-website-2024/vendor/statamic/cms/src/Providers/../../resources/views/roles/index.blade.php ENDPATH**/ ?>