<?php use function Statamic\trans as __; ?>


<?php $__env->startSection('title', __('Fieldsets')); ?>

<?php $__env->startSection('content'); ?>

    <?php if (! ($fieldsets->isEmpty())): ?>

        <div class="flex mb-6">
            <h1 class="flex-1"><?php echo e(__('Fieldsets')); ?></h1>
            <a href="<?php echo e(cp_route('fieldsets.create')); ?>" class="btn-primary"><?php echo e(__('Create Fieldset')); ?></a>
        </div>

        <?php $__currentLoopData = $fieldsets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $f): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="mb-4">
                <?php if($fieldsets->count() > 1): ?><h3 class="rtl:pr-0 ltr:pl-0 mb-2 little-heading"><?php echo e($key); ?></h3><?php endif; ?>
                <fieldset-listing :initial-rows="<?php echo e(json_encode($f)); ?>"></fieldset-listing>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    <?php else: ?>

        <?php echo $__env->make('statamic::partials.empty-state', [
            'title' => __('Fieldsets'),
            'description' => __('statamic::messages.fieldset_intro'),
            'svg' => 'empty/fieldsets',
            'button_text' => __('Create Fieldset'),
            'button_url' => cp_route('fieldsets.create'),
        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php endif; ?>

    <?php echo $__env->make('statamic::partials.docs-callout', [
        'topic' => __('Fieldsets'),
        'url' => Statamic::docsUrl('fieldsets')
    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('statamic::layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/amperative-website-2024/vendor/statamic/cms/src/Providers/../../resources/views/fieldsets/index.blade.php ENDPATH**/ ?>