<?php use function Statamic\trans as __; ?>


<?php $__env->startSection('title', __('Blueprints')); ?>

<?php $__env->startSection('content'); ?>

    <div class="flex justify-between items-center mb-6">
        <h1><?php echo $__env->yieldContent('title'); ?></h1>
        <div v-cloak>
        <dropdown-list class="inline-block">
            <template v-slot:trigger>
                <button class="button btn-primary flex items-center rtl:pl-4 ltr:pr-4">
                    <?php echo e(__('Create Blueprint')); ?>

                    <svg-icon name="micro/chevron-down-xs" class="w-2 rtl:mr-2 ltr:ml-2" />
                </button>
            </template>

            <?php $__currentLoopData = Statamic\Facades\Collection::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $collection): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if($loop->first): ?><h6 class="p-2"><?php echo e(__('Collections')); ?></h6><?php endif; ?>
                <dropdown-item redirect="<?php echo e(cp_route('collections.blueprints.create', $collection)); ?>" text="<?php echo e(__($collection->title())); ?>"></dropdown-item>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            <?php $__currentLoopData = Statamic\Facades\Taxonomy::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $taxonomy): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if($loop->first): ?><h6 class="p-2 mt-4"><?php echo e(__('Taxonomies')); ?></h6><?php endif; ?>
                <dropdown-item redirect="<?php echo e(cp_route('taxonomies.blueprints.create', $taxonomy)); ?>" text="<?php echo e(__($taxonomy->title())); ?>"></dropdown-item>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </dropdown-list>
        </div>
    </div>

    <?php $__currentLoopData = Statamic\Facades\Collection::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $collection): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php if($loop->first): ?>
        <h3 class="little-heading rtl:pr-0 ltr:pl-0 mb-2"><?php echo e(__('Collections')); ?></h3>
        <div class="card p-0 mb-4">
            <table class="data-table">
        <?php endif; ?>
                <?php $__currentLoopData = $collection->entryBlueprints(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blueprint): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td>
                            <div class="flex items-center">
                                <div class="w-4 h-4 rtl:ml-4 ltr:mr-4"><?php echo Statamic::svg('icons/light/content-writing') ?></div>
                                <span class="little-dot <?php echo e($blueprint->hidden() ? 'hollow' : 'bg-green-600'); ?> rtl:ml-2 ltr:mr-2" v-tooltip="'<?php echo e(__($blueprint->hidden() ? 'Hidden': 'Visible')); ?>'"></span>
                                <a href="<?php echo e(cp_route('collections.blueprints.edit', [$collection, $blueprint])); ?>" v-pre><?php echo e(__($blueprint->title())); ?></a>
                            </div>
                        </td>
                        <td class="rtl:text-left ltr:text-right text-2xs" v-pre><?php echo e(__($collection->title())); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php if($loop->last): ?>
            </table>
        </div>
        <?php endif; ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    <?php $__currentLoopData = Statamic\Facades\Taxonomy::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $taxonomy): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php if($loop->first): ?>
        <h3 class="little-heading rtl:pr-0 ltr:pl-0 mb-2"><?php echo e(__('Taxonomies')); ?></h3>
        <div class="card p-0 mb-4">
            <table class="data-table">
        <?php endif; ?>
                <?php $__currentLoopData = $taxonomy->termBlueprints(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blueprint): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td>
                            <div class="flex items-center">
                                <div class="w-4 h-4 rtl:ml-4 ltr:mr-4"><?php echo Statamic::svg('icons/light/tags') ?></div>
                                <span class="little-dot <?php echo e($blueprint->hidden() ? 'hollow' : 'bg-green-600'); ?> rtl:ml-2 ltr:mr-2" v-tooltip="'<?php echo e(__($blueprint->hidden() ? 'Hidden': 'Visible')); ?>'"></span>
                                <a href="<?php echo e(cp_route('taxonomies.blueprints.edit', [$taxonomy, $blueprint])); ?>" v-pre><?php echo e(__($blueprint->title())); ?></a>
                            </div>
                        </td>
                        <td class="rtl:text-left ltr:text-right text-2xs" v-pre><?php echo e(__($taxonomy->title())); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php if($loop->last): ?>
            </table>
        </div>
        <?php endif; ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    <?php $__currentLoopData = Statamic\Facades\Nav::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $nav): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php if($loop->first): ?>
        <h3 class="little-heading rtl:pr-0 ltr:pl-0 mb-2"><?php echo e(__('Navigation')); ?></h3>
        <div class="card p-0 mb-4">
            <table class="data-table">
        <?php endif; ?>
                <tr>
                    <td>
                        <div class="flex items-center">
                            <div class="w-4 h-4 rtl:ml-4 ltr:mr-4"><?php echo Statamic::svg('icons/light/hierarchy-files') ?></div>
                            <a href="<?php echo e(cp_route('navigation.blueprint.edit', $nav->handle())); ?>" v-pre><?php echo e(__($nav->title())); ?></a>
                        </div>
                    </td>
                </tr>
        <?php if($loop->last): ?>
            </table>
        </div>
        <?php endif; ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    <?php $__currentLoopData = Statamic\Facades\GlobalSet::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $set): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php if($loop->first): ?>
        <h3 class="little-heading rtl:pr-0 ltr:pl-0 mb-2"><?php echo e(__('Globals')); ?></h3>
        <div class="card p-0 mb-4">
            <table class="data-table">
        <?php endif; ?>
                <tr>
                    <td>
                        <div class="flex items-center">
                            <div class="w-4 h-4 rtl:ml-4 ltr:mr-4"><?php echo Statamic::svg('icons/light/earth') ?></div>
                            <a href="<?php echo e(cp_route('globals.blueprint.edit', $set->handle())); ?>" v-pre><?php echo e(__($set->title())); ?></a>
                        </div>
                    </td>
                </tr>
        <?php if($loop->last): ?>
            </table>
        </div>
        <?php endif; ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    <?php $__currentLoopData = Statamic\Facades\AssetContainer::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $container): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php if($loop->first): ?>
        <h3 class="little-heading rtl:pr-0 ltr:pl-0 mb-2"><?php echo e(__('Asset Containers')); ?></h3>
        <div class="card p-0 mb-4">
            <table class="data-table">
        <?php endif; ?>
                <tr>
                    <td>
                        <div class="flex items-center">
                            <div class="w-4 h-4 rtl:ml-4 ltr:mr-4"><?php echo Statamic::svg('icons/light/assets') ?></div>
                            <a href="<?php echo e(cp_route('asset-containers.blueprint.edit', $container->handle())); ?>" v-pre><?php echo e(__($container->title())); ?></a>
                        </div>
                    </td>
                </tr>
        <?php if($loop->last): ?>
            </table>
        </div>
        <?php endif; ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    <?php if(Statamic\Facades\User::current()->can('configure form fields')): ?>
        <?php $__currentLoopData = Statamic\Facades\Form::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $form): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php if($loop->first): ?>
        <h3 class="little-heading rtl:pr-0 ltr:pl-0 mb-2"><?php echo e(__('Forms')); ?></h3>
        <div class="card p-0 mb-2">
            <table class="data-table">
            <?php endif; ?>
                <tr>
                    <td>
                        <div class="flex items-center">
                            <div class="w-4 h-4 rtl:ml-4 ltr:mr-4"><?php echo Statamic::svg('icons/light/drawer-file') ?></div>
                            <a href="<?php echo e(cp_route('forms.blueprint.edit', $form->handle())); ?>" v-pre><?php echo e(__($form->title())); ?></a>
                        </div>
                    </td>
            <?php if($loop->last): ?>
                </tr>
        </table>
            <?php endif; ?>
    </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>

    <h3 class="little-heading rtl:pr-0 ltr:pl-0 mb-2"><?php echo e(__('Users')); ?></h3>
    <div class="card p-0 mb-4">
        <table class="data-table">
            <tr>
                <td>
                    <div class="flex items-center">
                        <div class="w-4 h-4 rtl:ml-4 ltr:mr-4"><?php echo Statamic::svg('icons/light/users') ?></div>
                        <a href="<?php echo e(cp_route('users.blueprint.edit')); ?>"><?php echo e(__('User')); ?></a>
                    </div>
                </td>
            </tr>
            <tr>
                <td>
                    <div class="flex items-center">
                        <div class="w-4 h-4 rtl:ml-4 ltr:mr-4"><?php echo Statamic::svg('icons/light/user_groups') ?></div>
                        <a href="<?php echo e(cp_route('user-groups.blueprint.edit')); ?>"><?php echo e(__('Group')); ?></a>
                    </div>
                </td>
            </tr>
        </table>
    </div>

    <?php $__currentLoopData = $additional; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $namespace): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <h3 class="little-heading rtl:pr-0 ltr:pl-0 mb-2"><?php echo e($namespace['title']); ?></h3>
    <div class="card p-0 mb-4">
        <table class="data-table">
        <?php $__currentLoopData = $namespace['blueprints']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blueprint): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td>
                    <div class="flex items-center">
                        <div class="w-4 h-4 rtl:ml-4 ltr:mr-4"><?php echo Statamic::svg('icons/light/blueprint') ?></div>
                        <a href="<?php echo e(cp_route('blueprints.edit', [$blueprint['namespace'], $blueprint['handle']])); ?>"><?php echo e($blueprint['title']); ?></a>
                    </div>
                </td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </table>
    </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    <?php echo $__env->make('statamic::partials.docs-callout', [
        'topic' => __('Blueprints'),
        'url' => Statamic::docsUrl('blueprints')
    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('statamic::layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/amperative-website-2024/vendor/statamic/cms/src/Providers/../../resources/views/blueprints/index.blade.php ENDPATH**/ ?>