<?php use function Statamic\trans as __; ?>


<?php $__env->startSection('title', Statamic::crumb($taxonomy->title(), 'Taxonomies')); ?>

<?php $__env->startSection('content'); ?>

<header class="mb-6">
    <?php echo $__env->make('statamic::partials.breadcrumb', [
        'url' => cp_route('taxonomies.index'),
        'title' => __('Taxonomies')
    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <h1><?php echo e(__($taxonomy->title())); ?></h1>
</header>

<div class="card p-4 content">
    <div class="flex flex-wrap">
        <a href="<?php echo e(cp_route('taxonomies.edit', $taxonomy->handle())); ?>" class="w-full lg:w-1/2 p-4 flex items-start hover:bg-gray-200 rounded-md group">
            <div class="h-8 w-8 rtl:ml-4 ltr:mr-4 text-gray-800">
                <?php echo Statamic::svg('icons/light/hammer-wrench') ?>
            </div>
            <div class="flex-1 mb-4 md:mb-0 rtl:md:ml-6 ltr:md:mr-6">
                <h3 class="mb-2 text-blue"><?php echo e(__('Configure Taxonomy')); ?> <?php echo Statamic::cpDirection() === 'ltr' ? '&rarr;' : '&larr;' ?></h3>
                <p><?php echo e(__('statamic::messages.taxonomy_next_steps_configure_description')); ?></p>
            </div>
        </a>
        <a href="<?php echo e(cp_route('taxonomies.terms.create', [$taxonomy->handle(), $site])); ?>" class="w-full lg:w-1/2 p-4 flex items-start hover:bg-gray-200 rounded-md group">
            <div class="h-8 w-8 rtl:ml-4 ltr:mr-4 text-gray-800">
                <?php echo Statamic::svg('icons/light/content-writing') ?>
            </div>
            <div class="flex-1 mb-4 md:mb-0 rtl:md:ml-6 ltr:md:mr-6">
                <h3 class="mb-2 text-blue"><?php echo e(__('Create Term')); ?> <?php echo Statamic::cpDirection() === 'ltr' ? '&rarr;' : '&larr;' ?></h3>
                <p><?php echo e(__('statamic::messages.taxonomy_next_steps_create_term_description')); ?></p>
            </div>
        </a>
        <a href="<?php echo e(Statamic::docsUrl('taxonomies')); ?>" target="_blank" class="w-full lg:w-1/2 p-4 flex items-start hover:bg-gray-200 rounded-md group">
            <div class="h-8 w-8 rtl:ml-4 ltr:mr-4 text-gray-800">
                <?php echo Statamic::svg('icons/light/book-pages') ?>
            </div>
            <div class="flex-1 mb-4 md:mb-0 rtl:md:ml-6 ltr:md:mr-6">
                <h3 class="mb-2 text-blue"><?php echo e(__('Read the Documentation')); ?> <?php echo Statamic::cpDirection() === 'ltr' ? '&rarr;' : '&larr;' ?></h3>
                <p><?php echo e(__('statamic::messages.taxonomy_next_steps_documentation_description')); ?></p>
            </div>
        </a>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('statamic::layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/amperative-website-2024/vendor/statamic/cms/src/Providers/../../resources/views/taxonomies/empty.blade.php ENDPATH**/ ?>