<?php

namespace Deployer;

// The Amperative dev server host details
host('amperative.dev')
    ->user('amperativedev')
    ->port(1948)
    ->stage('dev-site')
    ->set('branch', 'staging')
    ->set('deploy_path', '~/laravel-{{dev-site-name}}');

// Tasks
task('dev-site:setup', function () {
    $stage = get('stage');

    if ($stage === 'dev-site') {
        $output = run('php create-deployment.php {{dev-site-name}}');
        write($output);
    }
});

task('dev-site:install-env', function () {
    $stage = get('stage');

    if ($stage === 'dev-site') {
        $output = run('php install-env.php {{dev-site-name}}');
        write($output);
    }
});

// Set up the server.
before('deploy:prepare', 'dev-site:setup');

// Install the env file.
after('deploy:writable', 'dev-site:install-env');
