<?php
namespace Deployer;

require 'recipe/laravel.php';
require 'deploy/amperative_devsite.php';

// Subdomain name for the dev site
set('dev-site-name', 'website-2024');

// Project repository
set('repository', 'git@bitbucket.org:worthers/amperative-website-2024.git');

// [Optional] Allocate tty for git clone. Default value is false.
set('git_tty', true);

// PHP location
set('bin/php', '/usr/local/bin/ea-php81');

// Default stage
set('default_stage', 'dev-site');

// Composer
set('bin/composer', '{{bin/php}} /opt/cpanel/composer/bin/composer');

// Ensure we are using the branch that we are deploying to
desc('Local checkout.');
task('local_checkout',
    function() {
        // Get the branch from the selected remote host
        $branch = get('branch');

        writeln('Checking out the '. $branch. ' branch.');
        runLocally('git checkout ' . $branch);
        writeln('Done.');
    }
)->once();

// Run NPM to generate public files.
desc('Run vite.');
task(
    'run_vite',
    function() {
        // Compile the Assets
        writeln('Running npm install');
        run('npm install');
        writeln('Done.');

        writeln('Running vite build');
        run('vite build');
        writeln('Done.');
    }
)->local();

desc('Compile the assets locally before we upload them.');
task(
    'compile_assets',
    [
        'local_checkout',
        'run_vite'
    ]
)->onStage('dev-site');

// Upload the assets to the server
desc('Upload our compiled assests to the server');
task(
    'upload_assets',
    function () {
        // Upload the assets
        upload(__DIR__ . '/public/build', '{{release_path}}/public');
        upload(__DIR__ . '/content', '{{release_path}}/content');
    }
)->onStage('dev-site');

// Shared files/dirs between deploys
add('shared_files', []);
add('shared_dirs', []);

// Writable dirs by web server
add('writable_dirs', []);

set('allow_anonymous_stats', false);

// Hack the laravel recipe to prevent it from calling the now defunct optimize method
task(
    'artisan:optimize',
    function () {
    }
);

task('build', function () {
    run('cd {{release_path}} && build');
});

// Locally compile the assets before uploading them.
before('deploy', 'compile_assets');

// [Optional] if deploy fails automatically unlock.
after('deploy:failed', 'deploy:unlock');
